//belenusHome.registerModule("ImageView", self);

var HD3_MIME_TYPE = "application/x-hd3";
var TIFF_MIME_TYPE = "image/tiff";
var SVG_MIME_TYPE = "image/svg+xml";
var PDF_MIME_TYPE = "application/pdf";
var HTML_MIME_TYPE = "text/html";
var XVL_MIME_TYPE = "application/x-xvlplayer";
var CGM_MIME_TYPE = "image/cgm";
var JPEG_MIME_TYPE = "image/jpeg";
var GIF_MIME_TYPE = "image/gif";
var PNG_MIME_TYPE = "image/png";
var currentImageType = null; //HD3_MIME_TYPE;
var currentImageID = null;

function addAppletParam(appletNode, key, val) {
  var elem = document.createElement('param');
  elem.setAttribute("name", key);
  elem.setAttribute("value", val);
  appletNode.appendChild(elem);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// this version of "messageHandler" handles HD3 and TIFF messages
function messageHandlerApplet(message, params) {
  //alert("messageHandlerApplet: \nmessage: "+message+"\nparams: "+params);
  var paramArr = belenusHome.queryStringToArray(params);
  if(paramArr["MIMEType"] != null) currentImageType = paramArr["MIMEType"];
  else currentImageType = HD3_MIME_TYPE;
  
  if (message == "LoadImage") { ////////// LoadImage //////////
    currentImageID = paramArr['ImageID'];
    var ivc = document.getElementById("ImageViewCanvas");
    if(document.getElementById("ImageViewApplet")) { // just set new source
      //setTimeout('document.getElementById("ImageViewApplet").sendMessage("ImageView","'+message+'","'+params+'");',2);
      document.getElementById("ImageViewApplet").sendMessage("ImageView",message,params);
    } else { // fill applet into the layer
      if (!belenusHome.canAddAppletViaDOM()) {
        belenusHome.unregisterModule("ImageView");
        self.location = "imageview.html?Message0=ImageView,LoadImage," + escape(params);
      } else {
        while(ivc.hasChildNodes()) { // remove content
          var firstChildRef = ivc.firstChild;
          ivc.removeChild(firstChildRef);
        }
        var appletNode = document.createElement('applet');
        appletNode.setAttribute('id', 'ImageViewApplet');
        appletNode.setAttribute('code', 'com.belenus.interparts.PartsApplet');
        appletNode.setAttribute('mayscript', 'true');
        appletNode.setAttribute('width', '100%');
        appletNode.setAttribute('height', '100%');
        appletNode.setAttribute('vspace', '0');
        appletNode.setAttribute('hspace', '0');

        addAppletParam(appletNode, 'scriptable', 'true');
        var archive = 'core.jar,xml.jar,imageview.jar';
        if (belenusHome.usePNGLibrary == true) archive += ",png.jar";
        if (belenusHome.useTIFFLibrary == true) archive += ",tiff.jar";
        addAppletParam(appletNode, 'archive', archive);
        addAppletParam(appletNode, 'GUIDef', belenusHome.getPath('imageview_guidef.xml'));
        addAppletParam(appletNode, 'DataLocales', belenusHome.getLanguagesCurrentFirst('DATA'));
        addAppletParam(appletNode, 'LocaleDef', belenusHome.getPath('lang/'+belenusHome.currentLanguage+'/localedef.txt'));
        addAppletParam(appletNode, 'GUILocale', belenusHome.currentLanguage);
        var msgCount = 0;
        addAppletParam(appletNode, 'Message'+msgCount++, 'ImageView,'+message+',' + params);
        addAppletParam(appletNode, 'Message'+msgCount++, 'ImageView,EnableShopping,Enable=' + belenusHome.shoppingEnabled);
        //if(belenusHome.usePartslinkConnector == true) addAppletParam(appletNode, 'Message'+ msgCount++, 'ImageView,SetGUIParam,Name=MultiSelectionEnabled&Value=false');        
        
        var imageViewStyles = belenusHome.getImageViewStyleAppletParams();
        for(styles in imageViewStyles) addAppletParam(appletNode, "Message"+msgCount++, imageViewStyles[styles]);
      
        ivc.appendChild(appletNode);
      }
    }
	//currentImageType = paramArr["MIMEType"];
    setTimeout('belenusHome.eventHandler("SetDetailFrameViews","View=null");',123);
  // message LoadImage end
  } else if(document.getElementById("ImageViewApplet")) {
    try {
      //setTimeout('document.getElementById("ImageViewApplet").sendMessage("ImageView","'+message+'","'+params+'");',2);
      document.getElementById("ImageViewApplet").sendMessage("ImageView",message,params);
    } catch (e) {/*alert(e);*/}
  }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerSVG(message, params) {
	if(belenusHome.browserName == "Internet Explorer") {
		  var paramArr = belenusHome.queryStringToArray(params);
		  //alert(params);
		  if (message == "LoadImage") {////////// LoadImage //////////
		    currentImageID = paramArr['ImageID'];
		    var ivc = document.getElementById("ImageViewCanvas");
		    if(currentImageType != SVG_MIME_TYPE) {
		      while(ivc.hasChildNodes()) { // remove content
		        var firstChildRef = ivc.firstChild;
		        ivc.removeChild(firstChildRef);
		      }
		    }  
		    resetSVG();
		    if(currentImageType == SVG_MIME_TYPE) {
		      // just set new source
		      document.getElementById("SVGView").setSrc(unescape(paramArr['URL']));
		      resetSVG();
		      //document.getElementById("SVGView")
		    } else {
		      // embed svg plugin
		     if(paramArr['URL'] && belenusHome.browserName == "Internet Explorer") {
		        var svgNode = document.createElement('<embed id="SVGView" src="'+unescape(paramArr['URL'])+'" type="image/svg+xml" pluginspace="http://www.adobe.com/svg/viewer/install/" height="100%" width="100%"/>');
		        ivc.appendChild(svgNode);
		      } else { //firefox & mozilla + adobe svg-plugin 6.0
		      	var svgNode = document.createElement('object');
		      	svgNode.setAttribute("data", unescape(paramArr['URL']));
		      	svgNode.setAttribute("id", "SVGView");
		      	svgNode.setAttribute("type","image/svg+xml");
		      	svgNode.setAttribute("width","100%");
		      	svgNode.setAttribute("height","100%");
		      	ivc.appendChild(svgNode);
		      }
		      belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=ZoomIn&State0=Enabled&Name1=ZoomOut&State1=Disabled&Name2=FitToWin&State2=Disabled&Name3=FitToWidth&State3=Disabled&Name4=Lens&State4=Disabled&Name5=FreeScale&State5=Disabled&Name6=Print&State6=Enabled"
		      +"&Name7=Rotate3d&State7=Disabled&Name8=MoveHand&State8=Disabled&Name9=FitToWidthPart&State9=Disabled&Name10=HideOnePart&State10=Disabled&Name11=ShowAllParts&State11=Disabled&Name12=SemiTransparent&State12=Disabled");
		    }      
		    currentImageType = paramArr["MIMEType"];
		    belenusHome.eventHandler("SetDetailFrameViews","View=null");
		  // message LoadImage end 
		  } else if(message == "SelectHotspots") {////////// SelectHotspot //////////
		// TODO: implement selection of more than one hotspot at the same time
		  	selectedHotspot("HotspotID="+paramArr['HotspotID0']+"&Exclusive="+paramArr['Exclusive']);
		  } else if(message == "DeselectHotspots") {////////// DeselectHotspot ////////// 
		  	deselectHotspot("HotspotID="+paramArr['HotspotID0']);
		  } else if(message == "ZoomIn") {
		    zoomIn();
		  } else if(message == "ZoomOut") {
		    zoomOut();
		  } else if(message == "FitToWindow") {
		    zoomOrig();
		  }
	} else {
		var ivc = document.getElementById("ImageViewCanvas");
		var notSupported = document.createTextNode("Currently only the Internet Explorer supports the Adobe SVG-Plugin.");
		while(ivc.hasChildNodes()) { // remove content
			var firstChildRef = ivc.firstChild;
			ivc.removeChild(firstChildRef);
		}		
		belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=ZoomIn&State0=Disabled&Name1=ZoomOut&State1=Disabled&Name2=FitToWin&State2=Disabled&Name3=FitToWidth&State3=Disabled&Name4=Lens&State4=Disabled&Name5=FreeScale&State5=Disabled&Name6=Print&State6=Disabled");
      	ivc.appendChild(notSupported);
      	currentImageType = paramArr["MIMEType"];
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerPDF(message, params) {
  var paramArr = belenusHome.queryStringToArray(params);
  
  if (message == "LoadImage") { ////////// LoadImage //////////
    currentImageID = paramArr['ImageID'];
    var ivc = document.getElementById("ImageViewCanvas");
    if(currentImageType != PDF_MIME_TYPE) {
      while(ivc.hasChildNodes()) { // remove content
        var firstChildRef = ivc.firstChild;
        ivc.removeChild(firstChildRef);
      }
    }    
    if(paramArr['URL']) {
      var pdfNode = document.createElement('<iframe src="'+paramArr['URL']+'" width="100%" height="100%" frameborder="0">please download <a href="http://www.adobe.com/">acrobat reader</a></iframe>');
      ivc.appendChild(pdfNode);
    }    
    currentImageType = paramArr["MIMEType"];
    belenusHome.eventHandler("SetDetailFrameViews","View=null");
  //message LoadImage end
  } else if(message == "SelectHotspot") {} // SELECTION IN PDF NOT YET IMPLEMENTED
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerHTML(message, params) {
	var paramArr = belenusHome.queryStringToArray(params);
	
	if (message == "LoadImage") { ////////// LoadImage //////////
		currentImageID = paramArr['ImageID'];
		var ivc = document.getElementById('ImageViewCanvas');
		if (currentImageType != HTML_MIME_TYPE) {
			while (ivc.hasChildNodes()) { // remove content
				var firstChildRef = ivc.firstChild;
				ivc.removeChild(firstChildRef);
			}
			if (paramArr['URL']) {
				var htmlNode = document.createElement('iframe');
					htmlNode.setAttribute('src', paramArr['URL']);
					htmlNode.setAttribute('id', 'HTMLView');
					htmlNode.setAttribute('width', '100%'); 
					htmlNode.setAttribute('height', '100%');
					htmlNode.setAttribute('frameborder', '0');
				ivc.appendChild(htmlNode);
			} 			
		} else if (currentImageType == HTML_MIME_TYPE) {
	      // just set new source
	      document.getElementById('HTMLView').src = unescape(paramArr['URL']);
		} 
		currentImageType = HTML_MIME_TYPE;
		belenusHome.eventHandler('SetDetailFrameViews','View=null');
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerXVL(message, params) {
	var paramArr = belenusHome.queryStringToArray(params);
	
	if(message == "LoadImage") { ////////// LoadImage //////////
		var ivc = document.getElementById("ImageViewCanvas");
		if(currentImageType != XVL_MIME_TYPE) {
			while(ivc.hasChildNodes()) { // remove content
				var firstChildRef = ivc.firstChild;
				ivc.removeChild(firstChildRef);
			}			

			if(paramArr['URL']) {
				var xvl = '';
					xvl += '<object id="XVLPlayerX" width="100%" height="100%" classid="CLSID:C0975880-11DF-11D5-8084-0040B4116A31">';
					xvl += '<param name="Behavior" value="viewer">';
					xvl += '<param name="Options" value="EventAlways(GroupPick),ShowToolBar(off)">';
					xvl += '<param name="FileName" value="'+unescape(paramArr['URL'])+'">';
					xvl += '<param name="BgColor" value="#ffffff">';
					xvl += 'You need the <a style="color:blue;text-decoration:underline" href="http://www.lattice3d.com/" target="_blank">(free) Lattice 3D XVL Player</a><br>and a Microsoft Internet Explorer to see this 3D document.';
					xvl += '</object>';

					ivc.innerHTML=xvl;
					currentImageType = XVL_MIME_TYPE;
					belenusHome.eventHandler("SetDetailFrameViews","View=null");
					belenusHome.sendMessage("Toolbar","SetButtonStates",
						"Name0=ZoomIn&State0=Disabled&Name1=ZoomOut&State1=Disabled&"+
						"Name2=FitToWin&State2=Active&Name3=FitToWidth&State3=Disabled&"+
						"Name4=Lens&State4=Disabled&Name5=FreeScale&State5=Enabled&"+
						"Name6=Print&State6=Disabled&Name7=Rotate3d&State7=Pressed&"+
						"Name8=MoveHand&State8=Enabled&Name9=FitToWidthPart&State9=Enabled&"+
						"Name10=HideOnePart&State10=Enabled&Name11=ShowAllParts&State11=Enabled&"+
						"Name12=SemiTransparent&State12=Enabled");
			} 						
		} else {
		 	document.getElementById("XVLPlayerX").setAttribute("src",unescape(paramArr['URL']));
		}
		
	} else if(message == "SelectHotspots") { ////////// SelectHotspot //////////
	  	selectPart(paramArr['HotspotID0']);
	} else if(message == "MoveHandActivate") {
		XVLMoveHandActivate();
	} else if(message == "Rotate3dActivate") {
		XVLRotate3dActivate();
	} else if(message == "FitToWidthPart") {
		XVLFitToWidthPart();
	} else if(message == "HideSelectedPart") {
		XVLHideSelectedPart();
	} else if(message == "ShowAllParts") {
		XVLShowAllParts();
	} else if(message == "SemiTransparent") {
		XVLSemiTransparent();
	} else if(message == "FitToWindow") {
		XVLFitToWindow();
	} else if(message == "ToggleFreeScale") {
		XVLFreeScaleActivate();
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerCGM(message, params) {
	//alert("msgCGM:"+message+"\n\n"+params);
	var paramArr = belenusHome.queryStringToArray(params);
	
	if(message == "LoadImage") { ////////// LoadImage //////////
		var ivc = document.getElementById("ImageViewCanvas");
		if(currentImageType != CGM_MIME_TYPE) {
			while(ivc.hasChildNodes()) { // remove content
				var firstChildRef = ivc.firstChild;
				ivc.removeChild(firstChildRef);
			}			

			if(paramArr['URL']) {
				var cgm = '';
					cgm += '<object id="CGMPlayerX" width="100%" height="100%" classid="CLSID:865B2280-2B71-11D1-BC01-006097AC382A">';
					//cgm += '<param name="src" value="'+unescape(paramArr['URL'])+'">'; // using a setTimeout, trouble shooting...
					cgm += '<param name="BgColor" value="#ffffff">';
					cgm += 'You need the <a style="color:blue;text-decoration:underline" href="http://www.itedo.com/" target="_blank">ISOVIEW-Plugin</a><br>and a Microsoft Internet Explorer to see this document.';
					cgm += '</object>';

					ivc.innerHTML=cgm;
					currentImageType = CGM_MIME_TYPE;
					belenusHome.eventHandler("SetDetailFrameViews","View=null");
					belenusHome.sendMessage("Toolbar","SetButtonStates",
						"Name0=ZoomIn&State0=Disabled&Name1=ZoomOut&State1=Disabled&"+
						"Name2=FitToWin&State2=Disabled&Name3=FitToWidth&State3=Disabled&"+
						"Name4=Lens&State4=Disabled&Name5=FreeScale&State5=Disabled&"+
						"Name6=Print&State6=Disabled&Name7=Rotate3d&State7=Disabled&"+
						"Name8=MoveHand&State8=Disabled&Name9=FitToWidthPart&State9=Disabled&"+
						"Name10=HideOnePart&State10=Disabled&Name11=ShowAllParts&State11=Disabled&"+
						"Name12=SemiTransparent&State12=Disabled");
					
					setTimeout('document.getElementById("CGMPlayerX").Iso3OpenFile("'+unescape(paramArr['URL'])+'");',2000);
			} 						
		} else {
			CGMOpeningFile = true;
			document.getElementById("CGMPlayerX").Iso3OpenFile(unescape(paramArr['URL'])); //document.getElementById("CGMPlayerX").setAttribute("src",unescape(paramArr['URL']));
		}
	} else if(message == "SelectHotspots") { ////////// SelectHotspot //////////
	 	CGMSelectPart(params);
	} else if(message == "DeselectHotspots") {////////// DeselectHotspot ////////// 
  		var hsids = 0;
  		while(paramArr["HotspotID"+hsids])
	  		CGMDeselectPart(paramArr["HotspotID"+hsids++]);
  	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandlerSimpleImages(message, params) {
	var paramArr = belenusHome.queryStringToArray(params);
	
	if (message == "LoadImage") { ////////// LoadImage //////////
		currentImageID = paramArr['ImageID'];
		var ivc = document.getElementById("ImageViewCanvas");
		if(currentImageType != JPEG_MIME_TYPE && currentImageType != GIF_MIME_TYPE && currentImageType != PNG_MIME_TYPE) {
			while(ivc.hasChildNodes()) { // remove content
				var firstChildRef = ivc.firstChild;
				ivc.removeChild(firstChildRef);
			}
			if(paramArr['URL']) {
				var htmlNode = '<iframe src="about:blank" frameborder="0" width="100%" height="100%" scrolling="auto" name="SimpleImageCanvas" border="0"></iframe>';
				ivc.innerHTML = htmlNode;
				with(self.frames.SimpleImageCanvas.document) {
					open();
					write('<html><body leftmargin="0" topmargin="0"><table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0"><tr><td valign="middle" align="center"><img src="'+paramArr['URL']+'" id="SimpleImageView"></td></tr></table></body></html>');
					close();
				}
			} 			
		} else if(currentImageType == JPEG_MIME_TYPE || currentImageType == GIF_MIME_TYPE || currentImageType == PNG_MIME_TYPE) {
	      // just set new source
	      self.frames.SimpleImageCanvas.document.getElementById("SimpleImageView").setAttribute("src",unescape(paramArr['URL']));
		} 
		currentImageType = paramArr["MIMEType"];
		belenusHome.eventHandler("SetDetailFrameViews","View=null");
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function messageHandler(message, params) {
  //alert("IMAGEVIEW MESSAGEHANDLER\n"+message+"\n"+params);
  var paramArr = belenusHome.queryStringToArray(params);
  var mimeType = paramArr["MIMEType"];

  if(message == "ClearImageView") {
	clearImageView();
  }  

  if(!mimeType && currentImageType == null) return;
  else if(mimeType) {
    if(mimeType == HD3_MIME_TYPE || mimeType == TIFF_MIME_TYPE || (belenusHome.useAppletForStandardImageDisplaying && (mimeType == PNG_MIME_TYPE || mimeType == JPEG_MIME_TYPE || mimeType == GIF_MIME_TYPE))) {		
      if(belenusHome.browserName == "Internet Explorer") {
        if(document.getElementById("ImageViewApplet")) messageHandlerApplet(message, params);
        else setTimeout('messageHandlerApplet("'+message+'", "'+params+'");',200);  
      } else {
        if(document.getElementById("ImageViewApplet") && null == document.getElementById("ImageViewApplet").sendMessage) setTimeout('messageHandler("'+message+'","'+params+'")',2);
        else messageHandlerApplet(message, params);
      }
      
    } else if(mimeType == SVG_MIME_TYPE) messageHandlerSVG(message, params);
    else if(mimeType == PDF_MIME_TYPE) messageHandlerPDF(message, params);
    else if(mimeType == HTML_MIME_TYPE) messageHandlerHTML(message, params);
    else if(mimeType == XVL_MIME_TYPE) messageHandlerXVL(message, params);
    else if(mimeType == CGM_MIME_TYPE) messageHandlerCGM(message, params);
    else if(mimeType == JPEG_MIME_TYPE || mimeType == GIF_MIME_TYPE || mimeType == PNG_MIME_TYPE) messageHandlerSimpleImages(message, params);
    else { // none supported mime-type
      var ivc = document.getElementById("ImageViewCanvas");
      var unsupportedNode = document.createTextNode("Unsupported Mimetype: "+mimeType);
      ivc.appendChild(unsupportedNode);          
    }
  } else if(!mimeType && currentImageType != null) { 
    if(currentImageType == HD3_MIME_TYPE || currentImageType == TIFF_MIME_TYPE || (belenusHome.useAppletForStandardImageDisplaying && (mimeType == PNG_MIME_TYPE || mimeType == JPEG_MIME_TYPE || mimeType == GIF_MIME_TYPE))) {
      if(belenusHome.usePNGWithHSInformation && mimeType == PNG_MIME_TYPE) {
      	//reset mimeType 
      	var startCut = params.indexOf("MIMEType");
      	params = params.substring(0,startCut)+"MIMEType="+TIFF_MIME_TYPE+params.substring(startCut+8);
      	
      }

    
      if(belenusHome.browserName == "Internet Explorer") {
        if(document.getElementById("ImageViewApplet")) messageHandlerApplet(message, params);
        else setTimeout('messageHandlerApplet("'+message+'", "'+params+'");',200);  
      } else {
        if(document.getElementById("ImageViewApplet") && null == document.getElementById("ImageViewApplet").sendMessage) setTimeout('messageHandler("'+message+'","'+params+'")',2);
        else messageHandlerApplet(message, params);
      }
      
    } else if(currentImageType == SVG_MIME_TYPE) messageHandlerSVG(message, params);
    else if(currentImageType == PDF_MIME_TYPE) messageHandlerPDF(message, params);
    else if(mimeType == HTML_MIME_TYPE) messageHandlerHTML(message, params);
    else if(currentImageType == XVL_MIME_TYPE) messageHandlerXVL(message, params);
    else if(currentImageType == CGM_MIME_TYPE) messageHandlerCGM(message, params);
    else if(currentImageType == JPEG_MIME_TYPE || currentImageType == GIF_MIME_TYPE || currentImageType == PNG_MIME_TYPE) messageHandlerSimpleImages(message, params);
    else { // none supported mime-type
      var ivc = document.getElementById("ImageViewCanvas");
      var unsupportedNode = document.createTextNode("Unsupported Mimetype: "+mimeType);
      ivc.appendChild(unsupportedNode);          
    }  
  }
  
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function getProperty(property, params) {
	var appl = document.getElementById('ImageViewApplet');
	if (appl != null) {
		return appl.getProperty("ImageView", property, params);
	} else if(document.getElementById("SVGView")) {
		return "MIMEType=image/svg+xml&"+getSVGProperty();
	} else if(document.getElementById("HTMLView")) {
		return "MIMEType=text/html";
	}
}

function saveImage(winRef) {}

function printImage(winRef) {}	

function saveImage() {
  if (currentImageType == HD3_MIME_TYPE) {
    belenusHome.WM.openWindow("imagePrint","",true);
    var doc = belenusHome.WM.getWindowReference("imagePrint").document;
    doc.open();
    doc.write('<html><head><title>'+belenusHome.ld['defaultTitle']+'</title></head><body><img src="');
    doc.write(belenusHome.TableFrame.document.getElementById('ImageViewApplet').callAndReturn("Image","getImageURL")+'" width="100%" border="0"></body></html>');
    doc.close();
  }
}

function belItemSelected(querystring) {}

function selectItem(column, value) {
  belenusHome.TableFrame.ImageViewApplet.jsSelectPartByField(column, value)
}

function clearImageView() {
	var ivc = document.getElementById("ImageViewCanvas");
	while(ivc.hasChildNodes()) { // remove content
		var firstChildRef = ivc.firstChild;
		ivc.removeChild(firstChildRef);
	}
	belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=ZoomIn&State0=Disabled&Name1=ZoomOut&State1=Disabled&"
	+"Name2=FitToWin&State2=Disabled&Name3=FitToWidth&State3=Disabled&Name4=Lens&State4=Disabled&Name5=FreeScale&State5=Disabled&Name6=Print&State6=Disabled"
	+"&Name7=Rotate3d&State7=Disabled&Name8=MoveHand&State8=Disabled&Name9=FitToWidthPart&State9=Disabled&Name10=HideOnePart&State10=Disabled&"
	+"Name11=ShowAllParts&State11=Disabled&Name12=SemiTransparent&State12=Disabled");
	
    ivc.appendChild(document.createTextNode(belenusHome.ld['noImage']));
	currentImageType = null;
}
